/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.misc;

import com.glisco.things.Things;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import net.minecraft.class_5321;

public class SockDataComponent
implements Component,
ServerTickingComponent {
    private final class_1657 bearer;
    private class_5321<class_1937> lastWorld = null;
    public int sneakTicks = 0;
    public boolean jumpySocksEquipped = false;
    private float speedModification = 0.0f;
    private final Int2IntMap sockSpeeds = new Int2IntOpenHashMap();

    public SockDataComponent(class_1657 bearer) {
        this.bearer = bearer;
    }

    public void updateSockSpeed(int slot, int speed) {
        if (this.sockSpeeds.get(slot) == speed) {
            return;
        }
        this.modifySpeed(-Things.CONFIG.sockPerLevelSpeedAmplifier() * (float)this.sockSpeeds.get(slot));
        this.sockSpeeds.put(slot, speed);
        this.modifySpeed(Things.CONFIG.sockPerLevelSpeedAmplifier() * (float)speed);
    }

    public void modifySpeed(float amount) {
        if (amount == 0.0f) {
            return;
        }
        float cleanWalkSpeed = this.bearer.method_31549().method_7253() - this.speedModification;
        this.speedModification += amount;
        if (this.speedModification < 0.0f) {
            this.speedModification = 0.0f;
        }
        float modifiedSpeed = cleanWalkSpeed + this.speedModification;
        this.bearer.method_31549().method_7250(modifiedSpeed);
        this.bearer.method_5996(class_5134.field_23719).method_6192((double)modifiedSpeed);
        this.bearer.method_7355();
    }

    public void setModifier(float target) {
        this.modifySpeed(target - this.speedModification);
    }

    public void clearSockSpeed(int slot) {
        this.sockSpeeds.remove(slot);
    }

    public void readFromNbt(class_2487 tag) {
        this.speedModification = tag.method_10583("SpeedModification");
        this.sockSpeeds.clear();
        tag.method_10554("SockSpeeds", 10).forEach(element -> {
            class_2487 nbt = (class_2487)element;
            this.sockSpeeds.put(nbt.method_10550("Slot"), nbt.method_10550("Speed"));
        });
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10548("SpeedModification", this.speedModification);
        class_2499 list = new class_2499();
        this.sockSpeeds.forEach((slot, speed) -> {
            class_2487 nbt = new class_2487();
            nbt.method_10569("Slot", slot.intValue());
            nbt.method_10569("Speed", speed.intValue());
            list.add((Object)nbt);
        });
        tag.method_10566("SockSpeeds", (class_2520)list);
    }

    public void serverTick() {
        class_5321 playerWorld = this.bearer.field_6002.method_27983();
        if (this.lastWorld == null) {
            this.lastWorld = playerWorld;
        } else if (playerWorld != this.lastWorld) {
            float lastModifier = this.speedModification;
            this.setModifier(0.0f);
            this.setModifier(lastModifier);
            this.lastWorld = playerWorld;
        }
    }
}

